// Note: we not need v_clipVertex (CLIP version):
//	eyeSpaceVert == v_clipVertex

varying vec2	texCoord;
varying	vec3	Tangent;
varying	vec3	Binormal;
varying	vec3	Normal;
varying	vec3	eyeSpaceNormal;
varying	vec3	eyeSpaceVert;
uniform mat4	u_transformMatrix;
#ifndef CSM
	varying vec3	eyeVec;
#else
	varying	vec3	eyeSpaceTangent;
	varying	vec3	eyeSpaceBinormal;
#endif
include tcGen_noFog.inc
include deforms.inc
void main(void)
{
	vec4 glVertex = DeformGeometry();
	tcGen(texCoord, glVertex);
	vec4 glNormal = vec4(gl_Normal, 0.0);
	vec4 tc2 = vec4(gl_MultiTexCoord2.xyz, 0.0);
	vec4 tc3 = vec4(gl_MultiTexCoord3.xyz, 0.0);
	Tangent = (u_transformMatrix * tc2).xyz;
	Binormal = (u_transformMatrix * tc3).xyz;
	Normal = (u_transformMatrix * glNormal).xyz;
	eyeSpaceNormal = (gl_ModelViewMatrix * glNormal).xyz;
	eyeSpaceVert = (gl_ModelViewMatrix * glVertex).xyz;
#ifndef CSM
	vec3 temp = gl_ModelViewMatrixInverse[3].xyz - glVertex.xyz;
	eyeVec.x = dot(temp, tc2.xyz);
	eyeVec.y = dot(temp, tc3.xyz);
	eyeVec.z = abs(dot(temp, glNormal.xyz));
#else
	eyeSpaceTangent = (gl_ModelViewMatrix * tc2).xyz;
	eyeSpaceBinormal = (gl_ModelViewMatrix * tc3).xyz;
#endif
	gl_Position = gl_ModelViewProjectionMatrix * glVertex;
}
